function GetSongBanner(song)
	if song then
		local path = song:GetBannerPath()
		if path then return path end
	end
	return THEME:GetPathG("Common","fallback banner")
end

local t=Def.ActorFrame{};
local song = _SONG();
local jacketmode=0;
local course=GAMESTATE:GetCurrentCourse();
local steps={};

-- [ja] テスト 
--[[
t[#t+1]=Def.Actor{
OnCommand=function(self)
_SYS("START")
self:sleep(0.1);
local w="aaaaaaaaaaaaaaaaUTFaaaaaaa";
local f=OpenFile("Test.txt");
local w=f:Read();
CloseFile(f)
_SYS("TEXT OPENED")
self:sleep(0.1);
f=SaveFile("Test.txt");
f:Write(w.."".._SONG():GetDisplayFullTitle());
_SYS("TEXT SAVED")
self:sleep(0.1);
CloseFile(f)
t="SSS"
if string.find(w,t,0,true) then
	_SYS("SEARCH="..string.find(w,t,0,true))
else
	_SYS("Notfound")
end;
self:sleep(0.1);
end;
};
--]]
--

if song then
	-- [ja] こっそりBGA to Lua 
	BGAtoLUA(song);
	-- [ja] こっそりコンフィグ設定登録
	SetwaieiInfo("BGScale",GetUserPref_Theme("UserBGScale"));
	SetwaieiInfo("Haishin",GetUserPref_Theme("UserHaishin"));
	--[[
	-- [ja] こっそりSM5非対応命令保存 
	local var;
	var=GetSMParameter(song,"menucolor");
	if var~="" then
		SetExtendedParameter(song,"menucolor",var);
	end;
	var=GetSMParameter(song,"metertype");
	if var~="" and var~="DDR" then	-- [ja] DDRはデフォルトなので保存する必要ない 
		SetExtendedParameter(song,"metertype",var);
	end;
	var=GetSMParameter(song,"bgaspectratio");
	if var~="" then 
		SetExtendedParameter(song,"BGAspectRatio",var);
	end;
	--]]
	var=ReadUOP(song,"bgaspectratio");
	SetwaieiInfo("BGRatio",var);
	--[ja] 動画の切り替え時と最初のステップの時間差が1秒未満の場合余白を設定 
	--     何故か3.9と比較してちょっと遅めに再生されるので0.1秒早めに再生することでゴリ押し回避 
	--     -10000.0とか設定されてると落ちるんで-4.0まで 
	var=GetSMParameter(song,"bgchanges");
	local prm;
	local offset_min=0.5
	local movie_start=offset_min;
	local first_step=song:GetFirstSecond();
	local song_offset=0.0;
	if GetSMParameter(song,"offset")~="" then
		song_offset=tonumber(GetSMParameter(song,"offset"));
	elseif GetSMParameter(song,"gap")~="" then
		song_offset=tonumber(GetSMParameter(song,"gap"))*(-0.001);
	else
		song_offset=0;
	end;
	if var~="" then
		local file_offset=0.0;
		prm=split(",",var);
		for i=1,#prm do
			if string.find(prm[i],".avi",0,true) or string.find(prm[i],".mpg",0,true)
				or string.find(prm[i],".mpeg",0,true) or string.find(prm[i],".flv",0,true)
				or string.find(prm[i],".mp4",0,true) then
				file_offset=tonumber(split("=",prm[i])[1]);
				break;
			end;
		end;
		local movie_offset=song_offset-PlayerBeat2Sec(GetSidePlayer(PLAYER_1),file_offset)-first_step;
		if movie_offset>offset_min	and movie_offset<10.0 then
			movie_start=movie_offset-0.1;
		else
			movie_start=offset_min;
		end;
	end;
	var=GetSMParameter(song,"fgchanges");
	if var~="" and movie_start<=offset_min then
		local file_offset=0.0;
		prm=split(",",var);
		for i=1,#prm do
			if string.find(prm[i],".avi",0,true) or string.find(prm[i],".mpg",0,true)
				or string.find(prm[i],".mpeg",0,true) or string.find(prm[i],".flv",0,true)
				or string.find(prm[i],".mp4",0,true) then
				file_offset=tonumber(split("=",prm[i])[1]);
				break;
			end;
		end;
		local movie_offset=song_offset-PlayerBeat2Sec(GetSidePlayer(PLAYER_1),file_offset)-first_step;
		if movie_offset>offset_min	and movie_offset<10.0 then
			movie_start=movie_offset-0.1;
		else
			movie_start=offset_min;
		end;
	end;
	SetwaieiInfo("BGStart",math.max(movie_start/2,offset_min));
	--
	t[#t+1]=EXF_ScreenStageInformation();

end;

t[#t+1]=Def.ActorFrame{
	Lyric_Egg_S();
	Def.Actor{
		InitCommand=function(self)
			steps={GAMESTATE:GetCurrentSteps(GetSidePlayer(PLAYER_1)),GAMESTATE:GetCurrentSteps(GetSidePlayer(PLAYER_2))};
			if (not song) and course then
				local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber())
				local e = trail:GetTrailEntries()
				if #e > 0 then
					song = e[1]:GetSong()
					steps={e[1]:GetSteps(),e[1]:GetSteps()};
				end;
			end;
		end;
	};
	LoadActor(THEME:GetPathG("_Ready","Background")) .. {
		Name="BG";
		InitCommand=cmd(diffusealpha,0;zoom,2;Center;linear,0.25;diffusealpha,1;zoomy,1.5;zoomtowidth,SCREEN_WIDTH;sleep,1.5;linear,0.25;zoomy,1;sleep,0.5);
	};
	LoadActor(THEME:GetPathG("_Ready","Light L")) .. {
		Name="RLIGHTL";
		InitCommand=cmd(zoomtowidth,SCREEN_WIDTH;Center;
			diffuse,_DifficultyCOLOR(steps[1]:GetDifficulty());
			blend,'BlendMode_Add';);
		OnCommand=cmd(addx,640;diffusealpha,0;
			sleep,0.5;linear,1.45;addx,-640;diffusealpha,0.8;sleep,0.05;diffusealpha,1;sleep,0.5);
	};
	LoadActor(THEME:GetPathG("_Ready","Light R")) .. {
		Name="RLIGHTR";
		InitCommand=cmd(zoomtowidth,SCREEN_WIDTH;Center;
			diffuse,_DifficultyCOLOR(steps[2]:GetDifficulty());
			blend,'BlendMode_Add';);
		OnCommand=cmd(addx,-640;diffusealpha,0;
			sleep,0.5;linear,1.45;addx,640;diffusealpha,0.8;sleep,0.05;diffusealpha,1;sleep,0.5);
	};
	Def.Quad{
		Name="PICTG";
		InitCommand=function(self)
			self:LoadBackground(GetSongBanner(song));
			jacketmode=0;
			self:rate(1.0);
			self:scaletofit(0,0,192,60);
			self:y(SCREEN_CENTER_Y);
			self:x(SCREEN_CENTER_X-210);
			self:diffusealpha(0);
			self:addx(-30);
			self:sleep(1.8);
			self:linear(0.2);
			self:addx(30);
			self:diffusealpha(1);
			self:sleep(0.5);
		end;
		--InitCommand=cmd(zoomtowidth,SCREEN_WIDTH;Center;diffuse,Color("Blue");blend,'BlendMode_Add';);
--		OnCommand=cmd(diffusealpha,1;sleep,2.5;linear,0.5;diffusealpha,0;x,SCREEN_WIDTH;);
--		OnCommand=cmd(diffusealpha,1;sleep,2.5;cropright,0;diffuseleftedge,1,1,1,1;linear,0.5;diffusealpha,0;x,SCREEN_WIDTH;cropright,1;diffuseleftedge,1,1,1,0;);
	};
	Def.Quad{
		Name="PICTF";
		InitCommand=function(self)
		--[[
			if jacketmode==1 then
				self:LoadBackground(THEME:GetPathG("_Frame","Jacket"));
				self:scaletofit(0,0,200,200);
				self:y(SCREEN_CENTER_Y-40);
			else
		--]]
			self:LoadBackground(THEME:GetPathG("_Frame","Banner"));
			self:scaletofit(0,0,200,200);
			self:y(SCREEN_CENTER_Y);
			self:x(SCREEN_CENTER_X-210);
			self:diffusealpha(0);
			self:addx(-30);
			self:sleep(1.8);
			self:linear(0.2);
			self:addx(30);
			self:diffusealpha(1);
			self:sleep(0.5);
		end;
		--InitCommand=cmd(zoomtowidth,SCREEN_WIDTH;Center;diffuse,Color("Blue");blend,'BlendMode_Add';);
--		OnCommand=cmd(diffusealpha,1;sleep,2.5;linear,0.5;diffusealpha,0;x,SCREEN_WIDTH;);
--		OnCommand=cmd(diffusealpha,1;sleep,2.5;cropright,0;diffuseleftedge,1,1,1,1;linear,0.5;diffusealpha,0;x,SCREEN_WIDTH;cropright,1;diffuseleftedge,1,1,1,0;);
	};
	LoadFont("Common normal") .. {
		Name="STITLE";
		InitCommand=function(self)
			self:horizalign(left);
			self:x(SCREEN_CENTER_X-102);
			self:y(SCREEN_CENTER_Y-14);
			self:maxwidth(410/1.2);
			self:zoom(1.2);
			self:settextf("%s",song:GetDisplayFullTitle());
			self:strokecolor(Color("Outline"));
			self:diffusealpha(0);
			self:addx(-90);
			self:sleep(1.8);
			self:linear(0.2);
			self:addx(90);
			self:diffusealpha(1);
			self:sleep(0.5);
		end;
	};
	LoadFont("Common normal") .. {
		Name="SARTIST";
		InitCommand=function(self)
			self:horizalign(left);
			self:x(SCREEN_CENTER_X-100);
			self:y(SCREEN_CENTER_Y+16);
			self:maxwidth(410);
			self:settextf("%s",song:GetDisplayArtist());
			self:strokecolor(Color("Outline"));
			self:diffusealpha(0);
			self:addx(-90);
			self:sleep(1.8);
			self:linear(0.2);
			self:addx(90);
			self:diffusealpha(1);
			self:sleep(0.5);
		end;
	};
};

return t;
